Public Class Form1
    Inherits System.Windows.Forms.Form

    ' Variables membres.
    Private WithEvents ColtsViewGrid As System.Windows.Forms.DataGrid
    Private WithEvents RedCarViewGrid As System.Windows.Forms.DataGrid
    Private WithEvents btnChange As System.Windows.Forms.Button
    Private WithEvents txtRemove As System.Windows.Forms.TextBox
    Private WithEvents btnRemoveRow As System.Windows.Forms.Button
    Private WithEvents txtMake As System.Windows.Forms.TextBox
    Private WithEvents btnGetMake As System.Windows.Forms.Button
    Private WithEvents CarDataGrid As System.Windows.Forms.DataGrid
    Private WithEvents btnMakeDataTable As System.Windows.Forms.Button

    ' Notre objet DataTable.
    Private inventoryTable As DataTable = New DataTable("Inventory")

    ' Vues de l'objet DataTable.
    Private redCarsView As DataView ' Ne montrer que les voitures rouges.
    Private coltsView As DataView ' Ne montrer que les voitures Colts.

    ' Notre liste de voitures.
    Private arTheCars As ArrayList

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'Cet appel est requis par le concepteur Windows Form.
        InitializeComponent()

        ' Remplir l'objet ArrayList avec quelques voitures.
        arTheCars = New ArrayList()
        arTheCars.Add(New Car("Chucky", "BMW", "Vert"))
        arTheCars.Add(New Car("Tiny", "Yugo", "Blanc"))
        arTheCars.Add(New Car("", "Jeep", "Marron"))
        arTheCars.Add(New Car("Pain Inducer", "Caravan", "Rose"))
        arTheCars.Add(New Car("Fred", "BMW", "Vert"))
        arTheCars.Add(New Car("Buddha", "BMW", "Noir"))
        arTheCars.Add(New Car("Mel", "Firebird", "Rouge"))
        arTheCars.Add(New Car("Sarah", "Colt", "Noir"))

    End Sub

    'La classe Form surcharge la mthode dispose pour nettoyer la liste de composants.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Requis par le Concepteur Windows Form
    Private components As System.ComponentModel.Container

    'NOTE: La procdure suivante est requise par le Concepteur Windows Form
    'Elle peut tre modifie en utilisant le Concepteur Windows Form.  
    'Ne pas la modifier en utilisant le Concepteur Windows Form.
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.btnChange = New System.Windows.Forms.Button()
        Me.txtMake = New System.Windows.Forms.TextBox()
        Me.CarDataGrid = New System.Windows.Forms.DataGrid()
        Me.btnRemoveRow = New System.Windows.Forms.Button()
        Me.txtRemove = New System.Windows.Forms.TextBox()
        Me.ColtsViewGrid = New System.Windows.Forms.DataGrid()
        Me.RedCarViewGrid = New System.Windows.Forms.DataGrid()
        Me.btnGetMake = New System.Windows.Forms.Button()
        Me.btnMakeDataTable = New System.Windows.Forms.Button()
        CType(Me.CarDataGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.ColtsViewGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        CType(Me.RedCarViewGrid, System.ComponentModel.ISupportInitialize).BeginInit()
        Me.SuspendLayout()
        '
        'btnChange
        '
        Me.btnChange.Location = New System.Drawing.Point(248, 16)
        Me.btnChange.Name = "btnChange"
        Me.btnChange.Size = New System.Drawing.Size(192, 32)
        Me.btnChange.TabIndex = 6
        Me.btnChange.Text = "Changer toutes les BMWs en Colts"
        '
        'txtMake
        '
        Me.txtMake.Location = New System.Drawing.Point(128, 72)
        Me.txtMake.Name = "txtMake"
        Me.txtMake.Size = New System.Drawing.Size(80, 20)
        Me.txtMake.TabIndex = 3
        Me.txtMake.Text = ""
        '
        'CarDataGrid
        '
        Me.CarDataGrid.CaptionFont = New System.Drawing.Font("Microsoft Sans Serif", 10!)
        Me.CarDataGrid.CaptionText = "Toutes les voitures (vue par dfaut)"
        Me.CarDataGrid.DataMember = ""
        Me.CarDataGrid.Location = New System.Drawing.Point(16, 128)
        Me.CarDataGrid.Name = "CarDataGrid"
        Me.CarDataGrid.Size = New System.Drawing.Size(440, 136)
        Me.CarDataGrid.TabIndex = 1
        '
        'btnRemoveRow
        '
        Me.btnRemoveRow.Location = New System.Drawing.Point(248, 64)
        Me.btnRemoveRow.Name = "btnRemoveRow"
        Me.btnRemoveRow.Size = New System.Drawing.Size(112, 32)
        Me.btnRemoveRow.TabIndex = 4
        Me.btnRemoveRow.Text = "Enlever la ligne #"
        '
        'txtRemove
        '
        Me.txtRemove.Location = New System.Drawing.Point(368, 72)
        Me.txtRemove.Name = "txtRemove"
        Me.txtRemove.Size = New System.Drawing.Size(80, 20)
        Me.txtRemove.TabIndex = 5
        Me.txtRemove.Text = ""
        '
        'ColtsViewGrid
        '
        Me.ColtsViewGrid.CaptionFont = New System.Drawing.Font("Microsoft Sans Serif", 10!)
        Me.ColtsViewGrid.CaptionText = "Vue des voitures Colts uniquement"
        Me.ColtsViewGrid.DataMember = ""
        Me.ColtsViewGrid.Location = New System.Drawing.Point(16, 352)
        Me.ColtsViewGrid.Name = "ColtsViewGrid"
        Me.ColtsViewGrid.Size = New System.Drawing.Size(440, 72)
        Me.ColtsViewGrid.TabIndex = 8
        '
        'RedCarViewGrid
        '
        Me.RedCarViewGrid.CaptionFont = New System.Drawing.Font("Microsoft Sans Serif", 10!)
        Me.RedCarViewGrid.CaptionText = "Vue des voitures rouges uniquement"
        Me.RedCarViewGrid.DataMember = ""
        Me.RedCarViewGrid.Location = New System.Drawing.Point(16, 272)
        Me.RedCarViewGrid.Name = "RedCarViewGrid"
        Me.RedCarViewGrid.Size = New System.Drawing.Size(440, 72)
        Me.RedCarViewGrid.TabIndex = 7
        '
        'btnGetMake
        '
        Me.btnGetMake.Location = New System.Drawing.Point(8, 64)
        Me.btnGetMake.Name = "btnGetMake"
        Me.btnGetMake.Size = New System.Drawing.Size(112, 32)
        Me.btnGetMake.TabIndex = 2
        Me.btnGetMake.Text = "Rcuprer ces constructeurs:"
        '
        'btnMakeDataTable
        '
        Me.btnMakeDataTable.Location = New System.Drawing.Point(8, 16)
        Me.btnMakeDataTable.Name = "btnMakeDataTable"
        Me.btnMakeDataTable.Size = New System.Drawing.Size(112, 32)
        Me.btnMakeDataTable.TabIndex = 0
        Me.btnMakeDataTable.Text = "Construire l'objet DataTable"
        '
        'Form1
        '
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(470, 443)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.ColtsViewGrid, Me.RedCarViewGrid, Me.btnChange, Me.txtRemove, Me.btnRemoveRow, Me.txtMake, Me.btnGetMake, Me.CarDataGrid, Me.btnMakeDataTable})
        Me.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle
        Me.Name = "Form1"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "Car Data Table"
        CType(Me.CarDataGrid, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.ColtsViewGrid, System.ComponentModel.ISupportInitialize).EndInit()
        CType(Me.RedCarViewGrid, System.ComponentModel.ISupportInitialize).EndInit()
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private Sub btnMakeDataTable_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnMakeDataTable.Click
        ' Construire une table de donnes.
        MakeTable()

        ' Construire les vues.
        CreateViews()

        ' Termin. Dsactiver le bouton.
        btnMakeDataTable.Enabled = False
    End Sub

    Private Sub btnGetMake_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnGetMake.Click
        ' Construire un filtre bas sur la saisie de l'utilisateur.
        Dim filterStr As String = "Make='" + txtMake.Text + "'"
        Dim strMake As String
        ' Trouver toutes les lignes correspondant au filtre.
        Dim makes() As DataRow = _
        inventoryTable.Select(filterStr)

        Dim i As Integer

        ' Montrer ce que l'on obtient!
        If (makes.Length = 0) Then
            MessageBox.Show("Dsol, pas de voiture...", "Erreur de slection!")
        Else
            For i = 0 To makes.Length - 1
                Dim temp As DataRow = makes(i)
                strMake &= temp("PetName").ToString() & vbLf
            Next
            MessageBox.Show(strMake, "Type(s): " & txtMake.Text)
        End If

        ' Maintenant montrer le surnom de toutes les voitures 
        ' ayant un carID suprieur  1030.
        Dim properIDs As DataRow()
        Dim newFilterStr As String = "ID > '1030'"
        properIDs = inventoryTable.Select(newFilterStr)
        Dim strIDs As String

        For i = 0 To properIDs.Length - 1

            Dim temp As DataRow = properIDs(i)
            strIDs &= temp("PetName").ToString() _
                & " a l'ID " & temp("ID") & vbLf
        Next
        MessageBox.Show(strIDs, "Surnom des voitures dont l'ID est suprieur  1030")
    End Sub

    Private Sub btnChange_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnChange.Click
        ' Construire un filtre.
        Dim filterStr As String = "Make='BMW'"

        ' Trouver toutes les lignes correspondant au filtre.
        Dim makes() As DataRow = _
            inventoryTable.Select(filterStr)

        ' Les changer toutes!
        Dim i As Integer
        For i = 0 To makes.Length - 1
            Dim temp As DataRow = makes(i)
            temp("Make") = "Colt"
            makes(i) = temp
        Next
    End Sub

    Private Sub btnRemoveRow_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnRemoveRow.Click
        Try
            inventoryTable.Rows((Integer.Parse(txtRemove.Text))).Delete()
            inventoryTable.AcceptChanges()
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
    End Sub

    Private Sub MakeTable()

        ' variable DataColumn.
        Dim myDataColumn As DataColumn

        ' Crer la colonne ID et ajouter la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.Int32")
        myDataColumn.ColumnName = "ID"
        myDataColumn.ReadOnly = True
        myDataColumn.AllowDBNull = False
        myDataColumn.Unique = True

        'Fixer la proprit d'auto-incrment.
        myDataColumn.AutoIncrement = True
        myDataColumn.AutoIncrementSeed = 1000
        myDataColumn.AutoIncrementStep = 10

        inventoryTable.Columns.Add(myDataColumn)

        ' Crer la colonne Make et ajouter  la table.    
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.String")
        myDataColumn.ColumnName = "Make"
        inventoryTable.Columns.Add(myDataColumn)

        ' Crer la colonne Color et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.String")
        myDataColumn.ColumnName = "Color"
        inventoryTable.Columns.Add(myDataColumn)

        ' Crer la colonne PetName et l'ajouter  la table.
        myDataColumn = New DataColumn()
        myDataColumn.DataType = Type.GetType("System.String")
        myDataColumn.ColumnName = "PetName"
        myDataColumn.AllowDBNull = True
        inventoryTable.Columns.Add(myDataColumn)

        ' Dfinir la colonne ID comme colonne de clef principale.
        Dim PK(0) As DataColumn
        PK(0) = inventoryTable.Columns("ID")
        inventoryTable.PrimaryKey = PK

        ' Parcourir la liste de tableau pour construire les lignes.
        Dim c As Car
        For Each c In arTheCars
            Dim newRow As DataRow
            newRow = inventoryTable.NewRow()
            newRow("Make") = c.mMake
            newRow("Color") = c.mColor
            newRow("PetName") = c.mPetName
            inventoryTable.Rows.Add(newRow)
        Next

        ' Affecter  la grille.
        CarDataGrid.DataSource = inventoryTable
    End Sub

    Private Sub CreateViews()
        ' Fixer la table qui est utilise pour ces vues.
        redCarsView = New DataView(inventoryTable)
        coltsView = New DataView(inventoryTable)

        ' Maintenant configurer les vues...
        redCarsView.RowFilter = "Color = 'Rouge'"
        coltsView.RowFilter = "Make = 'colt'"

        ' Affecter aux grilles...
        RedCarViewGrid.DataSource = redCarsView
        ColtsViewGrid.DataSource = coltsView
    End Sub
End Class
